﻿using System;
using System.Collections;
using System.Collections.Generic;
using Unity.Mathematics;
using UnityEngine;
using UnityEngine.UI;

public class PushupMinigameController : MonoBehaviour
{
    public static PushupMinigameController instance;

    public GameObject pushupMinigame;

    public float decreaseSpeed = .10f;
    public float pumpSpeed = .05f;

    public string flagName = "Pushup";
    public GameObject[] objectsToActivateWhenFlagIsAccquired;
    public GameObject[] objectsToDeactivateWhenFlagIsAccquired;

    protected bool isActive = false;

    protected bool silenced;
    protected bool hasStarted;
    protected float tripLevel;
    protected bool isTripped;
    protected float percentage;
    protected float drawnPercentage;

    protected GameObject dialog;
    protected Slider slider;
    protected Animator stateAnimator;
    protected AudioSource audioSource;

    private void OnEnable()
    {
        instance = this;
        audioSource = GetComponent<AudioSource>();
        slider = pushupMinigame.transform.GetChild(0).GetComponent<Slider>();
        stateAnimator = pushupMinigame.transform.GetChild(1).GetComponent<Animator>();
        dialog = transform.GetChild(0).gameObject;
    }

    public void Activate()
    {
        isActive = true;

        hasStarted = false;
        tripLevel = GameController.instance.random.Next(40, 75) / 100f;
        isTripped = false;
        percentage = 0f;
        drawnPercentage = 0f;
        slider.SetPercentage(0f);

        pushupMinigame.SetActive(true);

        Player.instance.animator.SetBool("IsPushup", true);
        Player.instance.animator.SetBool("IsPushupStart", false);
        stateAnimator.SetBool("IsTripped", false);
    }

    public void Deactivate()
    {
        isActive = false;

        Player.instance.animator.SetBool("IsPushup", false);
        Player.instance.animator.SetBool("IsPushupStart", false);
        pushupMinigame.SetActive(false);
        dialog.SetActive(false);
        silenced = true;
    }

    protected void SetPanelText(string text)
    {
        dialog.transform.GetChild(0).GetComponent<Text>().text = text;
    }

    void Update()
    {
        if (silenced)
        {
            audioSource.volume = Mathf.Lerp(audioSource.volume, 0f, 0.05f);
        }

        if (!isActive)
        {
            return;
        }

        if (!isTripped && Input.GetButtonDown("P") || isTripped && Input.GetButtonDown("N"))
        {
            if (!hasStarted)
            {
                hasStarted = true;
                percentage += 3 * pumpSpeed;
                silenced = false;
                audioSource.volume = .75f;
                audioSource.Play();
                SetPanelText("You: Richard is really strong, this should be easy.");
                dialog.SetActive(true);
                Player.instance.animator.SetBool("IsPushupStart", true);
            }

            percentage += pumpSpeed;

            if (percentage >= 1f)
            {
                GameController.instance.AddFlag(flagName, objectsToActivateWhenFlagIsAccquired, objectsToDeactivateWhenFlagIsAccquired);
                GameController.instance.StopPushup();
                GameController.instance.StartDialog(new string[] { "Richard: I'm feeling pretty hungry, why was I even doing pushups out of nowhere?" }, () =>
                {
                    GameController.instance.DecreaseHazardCounter(55);
                });
            }
        }

        if (isTripped && Input.GetButtonDown("P"))
        {
            percentage -= 2 * pumpSpeed;
        }

        if (!isTripped && percentage > tripLevel)
        {
            isTripped = true;
            stateAnimator.SetBool("IsTripped", true);
            SetPanelText("Richard: Whats happening? I don't feel like myself.");
        }

        percentage = Mathf.Max(-0.001f, percentage - Time.deltaTime * decreaseSpeed);

        if (hasStarted && percentage <= 0f)
        {
            GameController.instance.StopPushup();
            GameController.instance.StartDialog(new string[] { "You couldn't mantain proper form while trying to control Richard." });
        }

        drawnPercentage = Mathf.Lerp(drawnPercentage, percentage, 0.1f);
        slider.SetPercentage(drawnPercentage);
    }
}
